### DRAW FIGURES 1 AND 2 FROM 'ECONOMETRIC PERSPECTIVES ON ECONOMIC MEASUREMENT'
### NEW USERS NEED TO CHANGE ENTRY IN LINE 5 ONLY

# Set file location for saving both charts
setwd("G:/Research/GorajekA - GENERAL/RDP Econometric Origins of Index Numbers/Replication Files") # Files will be saved to this folder

### NO NEED TO EDIT ANYTHING BEYOND THIS POINT #######################################################################################

# Set file type and name of Figure 1 
pdf("Figure 1.pdf", width = 7, height = 5) # Figure 1 will be saved with this name as a PDF

# Implement two-panel setup and margins
par(xpd = NA) # all plotting is restricted to the plotting regions
par(mfrow = c(1, 2)) # 2 by 2 panel layout; subsequent figures will be drawn by row
par(mar = c(0, 0, 0, 0)) # sets the margins between the panels
par(oma = c(4, 4.2, 2, 4.2)) # sets the margins outside the set of panels

# Draw homoskedastic scatterplot with stable weights in LHS panel
price <- c(4.4,4.5,4.6,4.7,4.8,4.7,4.8,4.6,4.7,4.8,4.9,5,4.9,5)
time <- c(0,0,0,0,0,0.06,0.06,1,1,1,1,1,1.06,1.06)
fill <- c(16,16,16,16,16,1,1,16,16,16,16,16,1,1)
plot(time,price,
     axes=FALSE,
     xlab="",
     xlim = c(-0.5, 1.5),
     xaxs = "i",
     ylab ="",
     ylim = c(4.2,5.4),
     yaxs = "i",
     pch = fill,
     cex=1.4)
box(col = "black")
mtext("Best case with endog. weights", side = 3, line = -1.2)
segments(0,mean(price[1:5]),1,mean(price[8:12]),col = "black", lty = 2, lwd = 2)
segments(0,mean(price[1:7]),1,mean(price[8:14]),col = "grey", lty = 2, lwd = 2)
axis(side=1, at=c(0, 1), labels=c("0", "1"), las=1)
axis(side=2, at=c(4.2,4.4,4.6,4.8,5,5.2,5.4), las=1)
legend(x=-0.5, 
       y=5.25, 
       pch=c(16,NA,1,NA),
       pt.cex=c(1.4,NA,1.4,NA),
       lty=c(NA,2,NA,2), 
       lwd =c(NA,2,NA,2),
       col = c("black","black","black","grey"),
       legend=c("OLS data", "OLS prediction", "WLS clones","WLS prediction"), 
       bty="o")

# Draw heteroskedastic scatterplot with stable weights in RHS panel
price <- c(4.4,4.5,4.6,4.7,4.8,4.7,4.8,4.4,4.6,4.8,5,5.2,5,5.2)
time <- c(0,0,0,0,0,0.06,0.06,1,1,1,1,1,1.06,1.06)
fill <- c(16,16,16,16,16,1,1,16,16,16,16,16,1,1)
plot(time,price,
     axes=FALSE,
     xlab="",
     xlim = c(-0.5, 1.5),
     xaxs = "i",
     ylab ="",
     ylim = c(4.2,5.4),
     yaxs = "i",
     pch = fill,
     cex=1.4)
box(col = "black")
mtext("Heterosked. with endog. weights", side = 3, line = -1.2)
segments(0,mean(price[1:5]),1,mean(price[8:12]),col = "black", lty = 2, lwd = 2)
segments(0,mean(price[1:7]),1,mean(price[8:14]),col = "grey", lty = 2, lwd = 2)
axis(side=1, at=c(0, 1), labels=c("0", "1"), las=1)
axis(side=4, at=c(4.2,4.4,4.6,4.8,5,5.2,5.4), las=1)

title("Stylised Scenarios", outer=TRUE)
mtext("Time", side = 1, line = 2.2, outer = TRUE)
mtext("ln(p)", side = 2, line = 2.5, outer = TRUE)
mtext("ln(p)", side = 4, line = 2.5, outer = TRUE)

dev.off()

## Set file type and name of Figure 2 
pdf("Figure 2.pdf", width=7, height = 5) # Figure 2 will be saved with this name as a PDF

par(xpd = NA) # clip everything to the plot space
par(mfrow = c(1, 2)) # 2 by 2 grid layout, subsequent figures will be drawn by row
par(mar = c(0, 0, 0, 0)) # sets the margins
par(oma = c(4, 4.2, 2, 4.2)) # sets the outer margins

# Draw heteroskedastic scatterplot with stable weights, now for LHS panel
price <- c(4.4,4.5,4.6,4.7,4.8,4.7,4.8,4.4,4.6,4.8,5,5.2,5,5.2)
time <- c(0,0,0,0,0,0.06,0.06,1,1,1,1,1,1.06,1.06)
fill <- c(16,16,16,16,16,1,1,16,16,16,16,16,1,1)
plot(time,
     price,
     axes=FALSE,
     xlab="",
     xlim = c(-0.5, 1.5),
     xaxs = "i",
     ylab ="",
     ylim = c(4.2,5.4),
     yaxs = "i",
     pch = fill,
     cex=1.4)
box(col = "black")
mtext("Old viewpoint", side = 3, line = -1.2)
segments(0,mean(price[1:5]),1,mean(price[8:12]),col = "black", lty = 2, lwd = 2)
segments(0,mean(price[1:7]),1,mean(price[8:14]),col = "grey", lty = 2, lwd = 2)
axis(side=1, at=c(0, 1), labels=c("0", "1"), las=1)
axis(side=2, at=c(4.2,4.4,4.6,4.8,5,5.2,5.4), las=1)
legend(x=-0.5, 
       y=5.25, 
       pch=c(16,NA,1,NA),
       pt.cex=c(1.4,NA,1.4,NA),
       lty=c(NA,2,NA,2), 
       lwd =c(NA,2,NA,2),
       col = c("black","black","black","grey"),
       legend=c("OLS data", "OLS prediction", "WLS clones","WLS prediction"), 
       bty="o")

# Draw the same scenario with the new viewpoint, for the RHS panel
price <- c(4.4,4.5,4.6,4.7,4.8,4.7,4.8,4.4,4.6,4.8,5,5.2,5,5.2)
time <- c(0,0,0,0,0,0.06,0.06,1,1,1,1,1,1.06,1.06)
fill <- c(16,16,16,16,16,16,16,16,16,16,16,16,16,16)
plot(time,price,
     axes=FALSE,
     xlab="",
     xlim = c(-0.5, 1.5),
     xaxs = "i",
     ylab ="",
     ylim = c(4.2,5.4),
     yaxs = "i",
     pch = fill,
     cex=1.4)
box(col = "black")
mtext("New viewpoint", side = 3, line = -1.2)
segments(0,mean(price[1:7]),1,mean(price[8:14]),col = "black", lty = 2, lwd = 2)
axis(side=1, at=c(0, 1), labels=c("0", "1"), las=1)
axis(side=4, at=c(4.2,4.4,4.6,4.8,5,5.2,5.4), las=1)

title("Changing Perspectives", outer=TRUE)
mtext("Time", side = 1, line = 2.2, outer = TRUE)
mtext("ln(p)", side = 2, line = 2.5, outer = TRUE)
mtext("ln(p)", side = 4, line = 2.5, outer = TRUE)

dev.off()